/** parse.h
 ** Parser data types.
 ** Written by Asher Hoskins, 29/10/94
 **/

#define MAXLABELLENGTH 5

typedef enum {
	T_NUMBER, T_BIGNUM, T_REGISTER, T_DATA_POINTER_DEF, T_DATA_POINTER,
	T_PROGRAM_POINTER_DEF, T_PROGRAM_POINTER, T_CONSTANT, T_CHANNEL,
	T_PROG_POINTER_STORE_DEF, T_ASSIGN, T_POINTS_TO, T_PREVIOUS, T_NEXT,
	T_PLUS, T_MINUS, T_MULTIPLY, T_DIVIDE, T_UMINUS, T_EQUAL, T_NOT_EQUAL,
	T_LESS_THAN, T_GREATER_THAN, T_LESS_THAN_OR_EQ, T_GREATER_THAN_OR_EQ,
	T_NEWLINE, T_ERROR
} token_t;

typedef enum {
	PE_TRUNC, PE_BADNUM, PE_BADTOK, PE_BADDIGIT
} parse_error_t;

typedef enum {
	TT_NUM, TT_DIG, TT_LAB, TT_TOK
} token_type_t;

typedef struct {
	token_t token;
	char format[4];
} token_def_t;

typedef struct {
	token_t token;
	union {
		int num;
		char digit;
		char label[MAXLABELLENGTH];
		parse_error_t errnum;
	} val;
} token_val_t;

token_val_t get_token(char *, int *);
