/*
   f98stack.c for fbbi.c
   Stack ANSI C Functions - source.
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.

   Why use this package?
   - It's ANSI C
   - You need to store one or more stack stacks,
     as defined in Funge-98 (http://www.cats-eye.com/funge/)

   Changes in v0.98:
   - FSS_DATATYPE is replaced with void * and dc (size in bytes)
   - stack stack is built upon stack with stack * as the cell type
*/

#include <string.h>
#include <stdlib.h>

#include <stdio.h>

#include "f98stack.h"

/* Given the number of cells (sc) and bytes per cell (dc), */
/* allocate a new stack */
stack * stack_alloc(long int sc, long int dc)
{
  stack * u;
  u = (stack *)malloc(sizeof(stack));
  if (u != NULL)
  {
    u->mem = malloc(sc * dc);
    if (u->mem != NULL)
    {
      u->sp = -1;
      u->sc = sc;
      u->dc = dc;
    } else return NULL;
  } else return NULL;
  SDEBUG("Successful Allocate", u);
  return u;
}

/* Given a pointer to a stack, remove and return the top cell */
void * stack_pop(stack * s)
{
  SDEBUG("Before Pop", s);
  if (s->sp >= 0)
  {
    return ((char *)s->mem + (s->sp-- * s->dc));
  } else return NULL;
}

/* Given a pointer to a stack and a value, place it on the */
/* top of the stack */
int stack_push(stack * s, void * val)
{
  SDEBUG("Before Push", s);
  if(s->sp < s->sc-1)
  {
    memcpy(((char *)s->mem + (++s->sp * s->dc)), val, s->dc);
    SDEBUG("Successful Push", s);
    return 1;
  } else return 0;
}

/* Pop a series of cells off the stack as chars until a 0 cell */
void stack_pop_string(stack * s, char * str)
{
  int i = 0;
  void * x = NULL;
  SDEBUG("Before Pop String", s);
  x = stack_pop(s);
  while ((s->sp >= 0) && (x != NULL) && (*(char *)x != 0))
  {
    str[i++] = *(char *)x;
    x = stack_pop(s);
  }
  str[i] = (char)'\0';
}

/* Push a series of chars onto the stack as cells until a 0 char */
void stack_push_string(stack * s, char * str)
{
  int i = strlen(str) + 1;
  long int l = 0;
  SDEBUG("Before Push String", s);
  while (i > 0)
  {
    l = (long)0 | str[--i]; /* pad */
    stack_push(s, &l);
  }
}

/* Given a pointer to a stack and a number of cells from the top */
/* cell, return an indexed cell without removing it */
void * stack_read(stack * s, int offset /* 0 = TOS */ )
{
  void * k = NULL;
  if(offset < 0) offset *= -1;
  SDEBUG("Before Read", s);
  if (s->sp >= offset)
  {
    k = (void *)((char *)s->mem + (s->sp - offset) * s->dc);
    return k;
  } else return NULL;
}

/* Return the number of elements on a given stack */
int stack_measure(stack * s)
{
  SDEBUG("Before Measure", s);
  if (s != NULL) return s->sp + 1; else return 0;
}

/* Remove all cells from a given stack */
void stack_clear(stack * s)
{
  SDEBUG("Before Clear", s);
  if (s != NULL) s->sp = -1;
}

/* Release all the memory used by a stack, invalidating the stack */
void stack_free(stack * s)
{
  SDEBUG("Before Free", s);
  if (s != NULL)
  {
    free(s->mem);
    free(s);
  }
}

/* Stack of stacks - transfer elements a la f98's {} instructions */
int stack_stack_transfer (stack * t, int count, void * zero)
{
  int i;
  stack * toss; stack * soss;
  void * q;

  SDEBUG("Before Transfer", t);
  if (stack_measure(t) > 1)
  {
    toss = (stack *)stack_read(t, 0);
    soss = (stack *)stack_read(t, 1);
    if (toss != NULL && soss != NULL)
    {
      if (count > 0) /* from SOSS to TOSS */
      {
        for(i=0;i<count;i++)
        {
          q = stack_read(soss, count - 1 - i);
          if (q != NULL) stack_push(toss, q); else stack_push(toss, zero);
        }
        soss->sp -= count;
        if (soss->sp < 0) soss->sp = -1;
      } else
      if (count < 0) /* from TOSS to SOSS */
      {
        count *= -1;
        for(i=0;i<count;i++)
        {
          q = stack_read(toss, count - 1 - i);
          if (q != NULL) stack_push(soss, q); else stack_push(soss, zero);
        }
        toss->sp -= count;
        if (toss->sp <= 0) toss->sp = -1;
      }
      return 1;
    }
  }
  return 0;
}
