/*
   bf98spc.h for bf98spc.c
   Dynamic Befunge-Space ANSI C Functions - header.
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.
*/

#ifndef _BF98SPC_H_
#define _BF98SPC_H_

#ifndef MAXLONG
  #define MAXLONG ((long)0x7fffffff)
#endif

/* The engine allocates the playfield in chunks of
   2^SNIPPET_BITS x 2^SNIPPET_BITS.  4 seems to be a good
   value (16x16x4=1024=1kbyte.)  Although you'll want to
   take this down if storage is unusually sparse,
   and bump it up if it's unusually compact. */

#define SNIPPET_BITS 4

#define SNIPPET_SIZE (1 << SNIPPET_BITS)
#define SNIPPET_MASK (SNIPPET_SIZE - 1)

/* internal storage definition of a 'snippet' (nxn chunk of space). */
typedef struct Snippet
{
  signed long int space[SNIPPET_SIZE * SNIPPET_SIZE];
} snippet;

/* internal storage definition of a key tree node or leaf. */
/* each node points to a single snippet of the playfield */
typedef struct KeyTree
{
  signed long int key_x;
  signed long int key_y;
  snippet * data;
  struct KeyTree * left;  /* xys less than xy */
  struct KeyTree * right; /* xys greater than xy */
} keytree;

typedef struct BefungeSpace
{
  signed long int max_x, max_y, min_x, min_y;
  keytree * root;
} bfspace;

extern bfspace *     bfspace_alloc (bfspace * p);
extern signed long int bfspace_fetch (bfspace * p, signed long int x, signed long int y);
extern int             bfspace_store (bfspace * p, signed long int x, signed long int y, signed long int data);
extern int             bfspace_inbounds (bfspace * p, signed long int x, signed long int y);
extern void            bfspace_free  (bfspace * p);
extern int             bfspace_fread (bfspace * p, FILE * f, signed long int x, signed long int y,
                        signed long int * w, signed long int * h, unsigned long int flags);
extern int	       bfspace_fwrite (bfspace * p, FILE * f, signed long int x, signed long int y,
			signed long int w, signed long int h, unsigned long int flags);

#endif  /* _BF98SPC_H_ not defined */
